#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>

using namespace std;

int highestRound(int N, vector<int>& powers, int Mi, int Ji) {
    // Find the index of Mi in the powers array
    int index = distance(powers.begin(), find(powers.begin(), powers.end(), Mi)) + 1;

    // Calculate the highest possible round
    int rounds = log2(N);

    // Check if swapping is possible and update rounds accordingly
    rounds = min(rounds, Ji);

    // Calculate the new position after swapping
    int newPosition = min(index + Ji, N);

    // Calculate the highest round the chosen friend can reach
    int highest = rounds + log2(newPosition);

    return highest;
}

int main() {
    // Input the number of friends
    int N;
    cin >> N;

    // Input the powers of friends
    vector<int> powers(N);
    for (int i = 0; i < N; ++i) {
        cin >> powers[i];
    }

    // Input the number of options
    int Q;
    cin >> Q;

    // Process each option
    for (int i = 0; i < Q; ++i) {
        int Mi, Ji;
        cin >> Mi >> Ji;

        // Output the result for each option
        cout << highestRound(N, powers, Mi, Ji) << endl;
    }

    return 0;
}